
import gurobipy as gp

# Create a new model
m = gp.Model("bike_stock")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="folding_bikes")
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="touring_bikes")

# Set objective function
m.setObjective(200*x + 350*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "demand_constr")
m.addConstr(550*x + 700*y <= 30000, "cost_constr")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of folding bikes: {x.x}")
    print(f"Number of touring bikes: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

