
from gurobipy import *

# Create a new model
m = Model("Bike_Stocking")

# Define the decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="folding_bikes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="touring_bikes")

# Set the objective function
m.setObjective(200*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "demand_constraint")
m.addConstr(550*x1 + 700*x2 <= 30000, "inventory_value_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Stock {x1.x} folding bikes")
    print(f"Stock {x2.x} touring bikes")
    print(f"Maximum profit: ${200*x1.x + 350*x2.x}")
else:
    print("No optimal solution found")

