
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(name="folding_bikes", lb=0, ub=100, vtype=gurobi.GRB.INTEGER)
y = m.addVar(name="touring_bikes", lb=0, ub=100, vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(200*x + 350*y, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, name="demand_constraint")
m.addConstr(550*x + 700*y <= 30000, name="value_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of folding bikes to stock: {x.varValue}")
    print(f"Number of touring bikes to stock: {y.varValue}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found.")
