
import gurobipy as gp

# Create a new model
m = gp.Model("knitting_problem")

# Create variables
blankets = m.addVar(vtype=gp.GRB.INTEGER, name="blankets")
sweaters = m.addVar(vtype=gp.GRB.INTEGER, name="sweaters")

# Set objective function
m.setObjective(5.5 * blankets + 5 * sweaters, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * blankets + 20 * sweaters <= 200, "yarn_constraint")
m.addConstr(5 * blankets + 4 * sweaters <= 40, "time_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of blankets to knit: {blankets.x}")
    print(f"Number of sweaters to knit: {sweaters.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

