
import gurobi

def solve_grandmother_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    B = model.addVar(name="Blankets", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    S = model.addVar(name="Sweaters", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(5.50 * B + 5 * S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30 * B + 20 * S <= 200, name="Yarn_Availability")
    model.addConstr(5 * B + 4 * S <= 40, name="Knitting_Time_Availability")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Blankets: {B.varValue}")
        print(f"Sweaters: {S.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_grandmother_problem()
