
import gurobipy as gp

# Create a new model
model = gp.Model("BathStoreOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="RubberDucks")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ToyBoats")

# Set the objective function
model.setObjective(2*x + 4*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 8*y <= 1000, "PreparationTime")
model.addConstr(3*x + 2*y <= 700, "TestingTime")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Rubber Ducks: {x.x}")
    print(f"Number of Toy Boats: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

