
from gurobipy import *

# Create a model
m = Model("Bath_Store_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rubber_ducks")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="toy_boats")

# Objective function: Maximize profit
m.setObjective(2*x + 4*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x + 8*y <= 1000, "preparation_time")
m.addConstr(3*x + 2*y <= 700, "testing_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of rubber ducks: {x.x}")
    print(f"Number of toy boats: {y.x}")
    print(f"Maximum profit: ${2*x.x + 4*y.x:.2f}")
else:
    print("No optimal solution found")
