
import gurobi

def solve_bath_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(name="rubber_ducks", lb=0, ub=None, obj=2)
    T = model.addVar(name="toy_boats", lb=0, ub=None, obj=4)

    # Add constraints
    model.addConstr(R * 5 + T * 8 <= 1000, name="preparation_time")
    model.addConstr(R * 3 + T * 2 <= 700, name="testing_time")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal solution found. Rubber ducks: {R.varValue}, Toy boats: {T.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

# Run the function
solve_bath_store_problem()
