
import gurobipy as gp

# Create a new model
model = gp.Model("IceCreamOptimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="cones")  # Number of cones
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="cups")  # Number of cups

# Set the objective function
model.setObjective(3*x + 3.5*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 4*y <= 500, "ice_cream_constraint")
model.addConstr(5*x + 6*y <= 1000, "toppings_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Number of Cones: {x.x:.2f}")
    print(f"Number of Cups: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

