
from gurobipy import *

# Create a model
m = Model("Ice Cream Optimization")

# Define decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="ice_cream_cones")
y = m.addVar(vtype=GRB.CONTINUOUS, name="ice_cream_cups")

# Objective function: Maximize revenue
m.setObjective(3*x + 3.5*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x + 4*y <= 500, "ice_cream_scoops")
m.addConstr(5*x + 6*y <= 1000, "toppings_grams")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sell {x.x} ice cream cones")
    print(f"Sell {y.x} ice cream cups")
    print(f"Max Revenue: ${3*x.x + 3.5*y.x}")
else:
    print("No optimal solution found")

