
import gurobi

# Create a new model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(name="ice_cream_cones", lb=0, ub=gurobi.GRB.INFINITY)
y = m.addVar(name="ice_cream_cups", lb=0, ub=gurobi.GRB.INFINITY)

# Define the objective function
m.setObjective(3 * x + 3.50 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(3 * x + 4 * y <= 500, name="scoops_constraint")
m.addConstr(5 * x + 6 * y <= 1000, name="toppings_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of ice cream cones to sell: {x.varValue}")
    print(f"Number of ice cream cups to sell: {y.varValue}")
    print(f"Maximum revenue: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
