
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("toy_production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="trains") # Number of trains
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="planes") # Number of planes

# Set objective function
m.setObjective(50*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 40*y <= 4000, "woodworker_time")
m.addConstr(y >= 3*x, "plane_production")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of trains to produce: {x.x}")
    print(f"Number of planes to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

