
from gurobipy import *

# Create a model
m = Model("Wooden Toys Production")

# Define the decision variables
T = m.addVar(vtype=GRB.INTEGER, name="Trains")
P = m.addVar(vtype=GRB.INTEGER, name="Planes")

# Objective function: Maximize profit
m.setObjective(50*T + 60*P, GRB.MAXIMIZE)

# Constraints
m.addConstr(30*T + 40*P <= 4000, "Time constraint")
m.addConstr(P >= 3*T, "Production ratio constraint")
m.addConstr(T >= 0, "Non-negativity of Trains")
m.addConstr(P >= 0, "Non-negativity of Planes")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Trains: {T.x}")
    print(f"Planes: {P.x}")
    print(f"Maximum profit: ${50*T.x + 60*P.x:.2f}")
else:
    print("No optimal solution found.")
