
import gurobi

def solve_toy_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    T = model.addVar(lb=0, name="T")  # Number of trains
    P = model.addVar(lb=0, name="P")  # Number of planes

    # Objective function: Maximize profit
    model.setObjective(50 * T + 60 * P, gurobi.GRB.MAXIMIZE)

    # Woodworker time constraint
    model.addConstr(30 * T + 40 * P <= 4000, name="woodworker_time")

    # Planes vs. trains constraint
    model.addConstr(P >= 3 * T, name="planes_vs_trains")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of trains: {T.varValue}")
        print(f"Number of planes: {P.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_toy_store_problem()
