
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("diet_problem")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="burgers") # Number of burgers
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="fries")   # Number of fries

# Set objective function
m.setObjective(7*x + 3*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(500*x + 300*y >= 3000, "calorie_req")
m.addConstr(30*x + 5*y >= 150, "protein_req")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Number of burgers: {x.x}")
    print(f"Number of fries: {y.x}")
    print(f"Minimum cost: ${m.objVal}")

