
from gurobipy import *

# Create a new model
m = Model("Diet_Optimization")

# Define decision variables
B = m.addVar(name='burgers', vtype=GRB.CONTINUOUS, lb=0)
F = m.addVar(name='fries', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function (minimize cost)
m.setObjective(7*B + 3*F, GRB.MINIMIZE)

# Add constraints
m.addConstr(500*B + 300*F >= 3000, name='calories')
m.addConstr(30*B + 5*F >= 150, name='protein')

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Burgers: {B.x}')
    print(f'Fries: {F.x}')
    print(f'Total Cost: ${7*B.x + 3*F.x:.2f}')
else:
    print('No optimal solution found')
