
import gurobi as gp

# Create a new model
m = gp.Model("diet_problem")

# Define the decision variables
B = m.addVar(name="burgers", lb=0, vtype=gp.GRB.CONTINUOUS)
F = m.addVar(name="fries", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: minimize cost
m.setObjective(7*B + 3*F, gp.GRB.MINIMIZE)

# Calorie requirement constraint
m.addConstr(500*B + 300*F >= 3000, name="calories")

# Protein requirement constraint
m.addConstr(30*B + 5*F >= 150, name="protein")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal:.2f}")
    print(f"Burgers: {B.varValue:.2f}")
    print(f"Fries: {F.varValue:.2f}")
else:
    print("No optimal solution found.")
