
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Optimization")

# Create decision variables
x = m.addVar(lb=0, name="Avocado_Investment")
y = m.addVar(lb=0, name="Kale_Investment")

# Set objective function
m.setObjective(0.05 * x + 0.08 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300000, "Total_Investment")
m.addConstr(x >= 90000, "Min_Avocado")
m.addConstr(y <= 180000, "Max_Kale")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in Avocado: ${x.x}")
    print(f"Optimal investment in Kale: ${y.x}")
    print(f"Maximum return: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

