
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define decision variables
x1 = m.addVar(lb=0, name="Avocado_Investment")
x2 = m.addVar(lb=0, name="Kale_Investment")

# Define the objective function: Maximize total return
m.setObjective(0.05*x1 + 0.08*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 300000, "Total_Investment")
m.addConstr(x1 >= 90000, "Min_Avocado_Investment")
m.addConstr(x2 <= 180000, "Max_Kale_Investment")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Avocado Investment: {x1.x}")
    print(f"Kale Investment: {x2.x}")
    print(f"Total Return: {0.05*x1.x + 0.08*x2.x}")
else:
    print("No optimal solution found.")
