
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="avocado_investment", lb=0)
    x2 = model.addVar(name="kale_investment", lb=0)

    # Objective function: Maximize 0.05x1 + 0.08x2
    model.setObjective(0.05 * x1 + 0.08 * x2, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 300000, name="total_investment")
    model.addConstr(x1 >= 0.3 * 300000, name="min_avocado_investment")
    model.addConstr(x2 <= 0.6 * 300000, name="max_kale_investment")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in avocado industry: $", x1.varValue)
        print("Optimal investment in kale industry: $", x2.varValue)
        print("Maximum return: ", 0.05 * x1.varValue + 0.08 * x2.varValue)
    else:
        print("No optimal solution found.")

solve_investment_problem()
