
import gurobipy as gp

# Create a new model
model = gp.Model("PCB_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="small_PCBs") #allowing fractional PCBs for now
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="large_PCBs")

# Set objective function
model.setObjective(20*x + 35*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 5*y <= 250, "silicon_constraint")
model.addConstr(30*x + 40*y <= 800, "design_constraint")
model.addConstr(20*x + 30*y <= 600, "soldering_constraint")
model.addConstr(x >= 5, "min_small_PCBs")
model.addConstr(y >= 6, "min_large_PCBs")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small PCBs: {x.x}")
    print(f"Number of large PCBs: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

