
from gurobipy import *

# Create a new model
m = Model("PCB_Production")

# Create variables
x_s = m.addVar(lb=5, vtype=GRB.INTEGER, name="small_pcb")
x_l = m.addVar(lb=6, vtype=GRB.INTEGER, name="large_pcb")

# Objective function: Maximize profit
m.setObjective(20*x_s + 35*x_l, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x_s + 5*x_l <= 250, "silicon")
m.addConstr(30*x_s + 40*x_l <= 800, "design_time")
m.addConstr(20*x_s + 30*x_l <= 600, "soldering_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small PCBs: {x_s.x}")
    print(f"Large PCBs: {x_l.x}")
    print(f"Total Profit: ${20*x_s.x + 35*x_l.x:.2f}")
else:
    print("No optimal solution found")
