
import gurobipy as gp

# Create a new model
m = gp.Model("PCB_Production")

# Variables
S = m.addVar(lb=5, name="Small_PCBs", vtype=gp.GRB.INTEGER)  # Minimum 5 small PCB's
L = m.addVar(lb=6, name="Large_PCBs", vtype=gp.GRB.INTEGER)  # Minimum 6 large PCB's

# Objective function: Maximize profit
m.setObjective(20*S + 35*L, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*S + 5*L <= 250, name="Silicon_Constraint")
m.addConstr(30*S + 40*L <= 800, name="Design_Time_Constraint")
m.addConstr(20*S + 30*L <= 600, name="Soldering_Time_Constraint")

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Produce {S.varValue} small PCB's and {L.varValue} large PCB's")
else:
    print("The model is infeasible")
