
from gurobipy import Model, GRB

# Create a new model
m = Model("Flower_Profit")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Sunflowers")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Roses")

# Set objective function
m.setObjective(200*x + 375*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 40, "Land_Constraint")
m.addConstr(5*x + 8*y <= 230, "Nutrition_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of sunflowers")
    print(f"Plant {y.x} acres of roses")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

