
from gurobipy import *

# Create a new model
m = Model("Florist_Optimization")

# Define the variables
sunflowers = m.addVar(lb=0, name="sunflowers")
roses = m.addVar(lb=0, name="roses")

# Set the objective function: Maximize profit
m.setObjective(200 * sunflowers + 375 * roses, GRB.MAXIMIZE)

# Add constraints
m.addConstr(sunflowers + roses <= 40, "total_land")
m.addConstr(5 * sunflowers + 8 * roses <= 230, "plant_nutrition")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sunflowers: {sunflowers.x} acres")
    print(f"Roses: {roses.x} acres")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found")

