
import gurobi

def solve_florist_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="sunflowers_acres")
    y = model.addVar(lb=0, name="roses_acres")

    # Objective function: maximize profit
    model.setObjective(200*x + 375*y, gurobi.GRB.MAXIMIZE)

    # Acres constraint
    model.addConstr(x + y <= 40, name="acres_constraint")

    # Plant nutrition constraint
    model.addConstr(5*x + 8*y <= 230, name="nutrition_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of sunflowers: {x.varValue}")
        print(f"Optimal acres of roses: {y.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_florist_problem()
