
import gurobipy as gp

# Create a new model
model = gp.Model("BananaTransportation")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="cars") # Number of cars
y = model.addVar(vtype=gp.GRB.INTEGER, name="bikes") # Number of bikes


# Set objective function: Maximize the number of bananas transported
model.setObjective(100*x + 30*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 6*y <= 200, "budget") # Budget constraint
model.addConstr(x < y, "traffic") # Traffic law constraint
# Non-negativity is implicit for integer variables but we can add them for clarity
model.addConstr(x >= 0, "non_neg_cars")
model.addConstr(y >= 0, "non_neg_bikes")


# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of bananas transported: {model.objVal}")
    print(f"Number of cars: {x.x}")
    print(f"Number of bikes: {y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

