
from gurobipy import *

# Create a new model
m = Model("Banana_Transport")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="cars", lb=0)
y = m.addVar(vtype=GRB.INTEGER, name="bikes", lb=0)

# Set the objective function: Maximize the total number of bananas transported
m.setObjective(100*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 6*y <= 200, "cost_constraint")
m.addConstr(y >= x + 1, "traffic_law_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cars: {x.x}")
    print(f"Number of bikes: {y.x}")
    print(f"Total bananas transported: {100*x.x + 30*y.x}")
else:
    print("No optimal solution found.")
