
import gurobi

def solve_banana_transportation():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    C = model.addVar(lb=0, name="C")  # Number of cars
    B = model.addVar(lb=0, name="B")  # Number of bikes

    # Objective function: Maximize the number of bananas transported
    model.setObjective(100*C + 30*B, gurobi.GRB.MAXIMIZE)

    # Cost constraint: 10C + 6B <= 200
    model.addConstr(10*C + 6*B <= 200, name="Cost_Constraint")

    # Traffic law constraint: C < B
    model.addConstr(C - B <= -1, name="Traffic_Law_Constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: C = {C.varValue}, B = {B.varValue}")
        print(f"Maximum bananas transported: {100*C.varValue + 30*B.varValue}")
    else:
        print("The model is infeasible.")

solve_banana_transportation()
