
import gurobipy as gp

# Create a new model
model = gp.Model("Software_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="student_version")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="professional_version")

# Set objective function
model.setObjective(400*x + 1500*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 350, "production_limit")
model.addConstr(750*x + 3000*y <= 500000, "budget_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of student versions to produce: {x.x}")
    print(f"Number of professional versions to produce: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

