
from gurobipy import *

# Create a new model
m = Model("Software_Production")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="student_version")
y = m.addVar(vtype=GRB.CONTINUOUS, name="professional_version")

# Set the objective function to maximize profit
m.setObjective(400*x + 1500*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 350, "combined_licenses")
m.addConstr(750*x + 3000*y <= 500000, "production_budget")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Student versions to produce: {x.x}")
    print(f"Professional versions to produce: {y.x}")
    print(f"Maximum profit: ${400*x.x + 1500*y.x}")
else:
    print("No optimal solution found")
