
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    S = model.addVar(lb=0, name="Student_Version")
    P = model.addVar(lb=0, name="Professional_Version")

    # Objective function: Maximize profit
    model.setObjective(400 * S + 1500 * P, gurobi.GRB.MAXIMIZE)

    # Production cost constraint
    model.addConstr(750 * S + 3000 * P <= 500000, name="Production_Cost_Constraint")

    # Sales constraint
    model.addConstr(S + P <= 350, name="Sales_Constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Student Version = {S.varValue}, Professional Version = {P.varValue}")
        print(f"Max Profit: ${model.objVal}")
    else:
        print("The model is infeasible.")

solve_production_problem()
