
import gurobipy as gp

# Create a new model
model = gp.Model("CarProduction")

# Create decision variables
e = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="e") # Electric cars
g = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="g") # Gas cars

# Set objective function
model.setObjective(5000*e + 3000*g, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(e <= 3, "ElectricProduction")
model.addConstr(g <= 5, "GasProduction")
model.addConstr(e + g <= 5, "FinishingCapacity")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Electric Cars (e): {e.x}")
    print(f"Gas Cars (g): {g.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

