
from gurobipy import *

# Create a model
m = Model("Car_Production")

# Define the decision variables
E = m.addVar(name="Electric_Cars", vtype=GRB.INTEGER, lb=0)
G = m.addVar(name="Gas_Cars", vtype=GRB.INTEGER, lb=0)

# Define the objective function
m.setObjective(5000*E + 3000*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(E <= 3, name="Electric_Factory_Capacity")
m.addConstr(G <= 5, name="Gas_Factory_Capacity")
m.addConstr(E + G <= 5, name="Finishing_Touches_Factory_Capacity")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Electric Cars: {E.x}")
    print(f"Gas Cars: {G.x}")
    print(f"Maximum Profit: ${5000*E.x + 3000*G.x}")
else:
    print("No optimal solution found")
