
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    E = model.addVar(lb=0, name="Electric_Cars")  # Electric cars
    G = model.addVar(lb=0, name="Gas_Cars")    # Gas cars

    # Objective function: Maximize profit
    model.setObjective(5000 * E + 3000 * G, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(E <= 3, name="Electric_Car_Factory_Limit")  # Electric car factory limit
    model.addConstr(G <= 5, name="Gas_Car_Factory_Limit")      # Gas car factory limit
    model.addConstr(E + G <= 5, name="Finishing_Factory_Limit")  # Finishing factory limit

    # Solve the problem
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Electric Cars = {E.varValue}, Gas Cars = {G.varValue}")
        print(f"Max Profit: ${5000 * E.varValue + 3000 * G.varValue}")
    else:
        print("No optimal solution found")

solve_problem()
