
import gurobipy as gp

# Create a new model
m = gp.Model("chandelier_production")

# Create variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="glass_chandeliers")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="brass_chandeliers")

# Set objective function
m.setObjective(400 * x + 300 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x + 1.5 * y <= 750, "crafting_constraint")
m.addConstr(x + 0.75 * y <= 500, "installation_constraint")
m.addConstr(x >= 0, "glass_nonnegativity")
m.addConstr(y >= 0, "brass_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of glass chandeliers: {x.x}")
    print(f"Number of brass chandeliers: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

