
from gurobipy import *

# Create a new model
m = Model("Chandelier_Optimization")

# Define variables
G = m.addVar(vtype=GRB.CONTINUOUS, name="Glass_Chandeliers")
B = m.addVar(vtype=GRB.CONTINUOUS, name="Brass_Chandeliers")

# Set the objective function: Maximize profit
m.setObjective(400*G + 300*B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*G + 1.5*B <= 750, "Crafting_Time_Constraint")
m.addConstr(G + 0.75*B <= 500, "Installation_Time_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {G.x} glass chandeliers and {B.x} brass chandeliers.")
    print(f"Maximum profit: ${400*G.x + 300*B.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")

