
import gurobi as gp

# Create a new model
m = gp.Model("Chandelier_Problem")

# Define the decision variables
G = m.addVar(name="Glass_Chandeliers", lb=0, vtype=gp.GRB.CONTINUOUS)
B = m.addVar(name="Brass_Chandeliers", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(400 * G + 300 * B, gp.GRB.MAXIMIZE)

# Add the constraints
m.addConstr(2 * G + 1.5 * B <= 750, name="Crafting_Hours")
m.addConstr(G + 0.75 * B <= 500, name="Installation_Hours")

# Solve the model
m.optimize()

# Check if the model is optimized
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Glass Chandeliers = {G.varValue}, Brass Chandeliers = {B.varValue}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("The model is infeasible or has an error.")
