
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("investment_problem")

    # Create variables
    x = m.addVar(name="trust_investment")  # Investment in trust
    y = m.addVar(name="savings_investment") # Investment in savings

    # Set objective function
    m.setObjective(0.02 * x + 0.03 * y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 60000, "total_investment")
    m.addConstr(x >= 0.15 * 60000, "min_trust")
    m.addConstr(y <= 0.80 * 60000, "max_savings")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal investment in trust: ${x.x:.2f}")
        print(f"Optimal investment in savings: ${y.x:.2f}")
        print(f"Maximum return: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
