
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define the decision variables
x = m.addVar(lb=9000, name="trust_investment")  # Lower bound to ensure at least 15% investment
y = m.addVar(lb=0, ub=48000, name="savings_account_investment")  # Upper bound for at most 80%

# Objective function: Maximize return on investment
m.setObjective(0.02*x + 0.03*y, GRB.MAXIMIZE)

# Constraint: Total investment is $60,000
m.addConstr(x + y == 60000, "total_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Trust Investment: ${x.x:.2f}")
    print(f"Savings Account Investment: ${y.x:.2f}")
    print(f"Total Return: ${0.02*x.x + 0.03*y.x:.2f}")
else:
    print("No optimal solution found")
