
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    T = model.addVar(name="Trust_Investment", lb=0)
    S = model.addVar(name="Savings_Account_Investment", lb=0)

    # Objective function: Maximize 0.02T + 0.03S
    model.setObjective(0.02 * T + 0.03 * S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(T + S <= 60000, name="Total_Investment_Constraint")
    model.addConstr(T >= 0.15 * 60000, name="Minimum_Trust_Constraint")
    model.addConstr(S <= 0.80 * 60000, name="Maximum_Savings_Constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Trust Investment: ${T.varValue:.2f}")
        print(f"Optimal Savings Account Investment: ${S.varValue:.2f}")
        print(f"Optimal Return: ${0.02 * T.varValue + 0.03 * S.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
