
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("BakeryOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="pies") # Number of pies
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="tarts") # Number of tarts

# Set objective function
model.setObjective(8*x + 5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 3*y <= 1000, "blueberry_constraint")
model.addConstr(y >= 3*x, "tart_production_constraint")
model.addConstr(x >= 30, "pie_production_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of pies to bake: {x.x}")
    print(f"Number of tarts to bake: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

