
from gurobipy import *

# Create a model
m = Model("Bakery_Optimization")

# Define decision variables
P = m.addVar(vtype=GRB.INTEGER, name="pies")
T = m.addVar(vtype=GRB.INTEGER, name="tarts")

# Set objective function: Maximize profit
m.setObjective(8*P + 5*T, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*P + 3*T <= 1000, "blueberry_limit")
m.addConstr(T >= 3*P, "tart_to_pie_ratio")
m.addConstr(P >= 30, "minimum_pies")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pies: {P.x}")
    print(f"Tarts: {T.x}")
    print(f"Maximum Profit: ${8*P.x + 5*T.x:.2f}")
else:
    print("No optimal solution found.")
