
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(lb=0, name="Pies")
    T = model.addVar(lb=0, name="Tarts")

    # Objective function: Maximize profit
    model.setObjective(8 * P + 5 * T, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * P + 3 * T <= 1000, name="Blueberry_Limit")
    model.addConstr(T >= 3 * P, name="Tart_to_Pie_Ratio")
    model.addConstr(P >= 30, name="Minimum_Pies")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Pies = {P.varValue}, Tarts = {T.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_bakery_problem()
