
import gurobipy as gp

# Create a new model
model = gp.Model("Hoodie_Sweater_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hoodies")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sweaters")

# Set objective function
model.setObjective(20 * x + 15 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x + 2 * y <= 500, "fabric_constraint")
model.addConstr(2 * x + 1.5 * y <= 300, "dye_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of hoodies to produce: {x.x}")
    print(f"Number of sweaters to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

