
from gurobipy import *

# Create a new model
model = Model("Production_Optimization")

# Define the decision variables
H = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Hoodies")
S = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Sweaters")

# Define the objective function
model.setObjective(20*H + 15*S, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*H + 2*S <= 500, "Fabric_Constraint")
model.addConstr(2*H + 1.5*S <= 300, "Dye_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Hoodies: {H.x}")
    print(f"Number of Sweaters: {S.x}")
    print(f"Total Profit: ${20*H.x + 15*S.x:.2f}")
else:
    print("No optimal solution found.")

