
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    H = model.addVar(lb=0, name="Hoodies")
    S = model.addVar(lb=0, name="Sweaters")

    # Objective function: Maximize profit
    model.setObjective(20 * H + 15 * S, gurobi.GRB.MAXIMIZE)

    # Fabric constraint
    model.addConstr(3 * H + 2 * S <= 500, name="Fabric_Constraint")

    # Dye constraint
    model.addConstr(2 * H + 1.5 * S <= 300, name="Dye_Constraint")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of hoodies to produce: {H.varValue}")
        print(f"Number of sweaters to produce: {S.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_production_problem()
