
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("salad_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="individual_salads") # Integer since you can't sell fractions of salads
y = m.addVar(vtype=GRB.INTEGER, name="family_salads")

# Set objective
m.setObjective(4*x + 7*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 18*y <= 220, "lettuce_constraint")
m.addConstr(2*x + 6*y <= 150, "tomatoes_constraint")
m.addConstr(2*x + 5*y <= 140, "sauce_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of individual salads: {x.x}")
    print(f"Number of family salads: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

