
from gurobipy import *

# Create a new model
m = Model("Salad_Sales")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="individual_salads")
y = m.addVar(vtype=GRB.CONTINUOUS, name="family_sized_salads")

# Objective function: Maximize profit
m.setObjective(4*x + 7*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x + 18*y <= 220, "lettuce")
m.addConstr(2*x + 6*y <= 150, "tomatoes")
m.addConstr(2*x + 5*y <= 140, "sauce")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Individual salads: {x.x}")
    print(f"Family-sized salads: {y.x}")
    print(f"Maximum profit: ${4*x.x + 7*y.x:.2f}")
else:
    print("No optimal solution found")
