
import gurobi

def solve_salad_bowl_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="individual_salad", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="family_salad", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(4 * x + 7 * y, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x + 18 * y <= 220, name="lettuce_constraint")
    model.addConstr(2 * x + 6 * y <= 150, name="tomatoes_constraint")
    model.addConstr(2 * x + 5 * y <= 140, name="sauce_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

if __name__ == "__main__":
    solve_salad_bowl_problem()
